import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.geom.*;

public class ClockPanel extends JPanel implements ActionListener {
	private JButton tickButton, resetButton;
	private JLabel hourLabel, minuteLabel;
	private int minutes = 720; // 12 noon

	public ClockPanel() {
		JPanel panel = new JPanel();

		tickButton = new JButton("Tick");
		resetButton = new JButton("Reset");
		hourLabel = new JLabel("12:");
		minuteLabel = new JLabel("00");

		panel.add(tickButton);
		panel.add(resetButton);
		panel.add(hourLabel);
		panel.add(minuteLabel);

		setLayout(new BorderLayout());
		add(panel, BorderLayout.SOUTH);

		tickButton.addActionListener(this);
		resetButton.addActionListener(this);
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2= (Graphics2D) g;
		Shape e= new Ellipse2D.Double(100, 0, 100, 100);
		g2.draw(e);
		double hourAngle = 2 * Math.PI * (minutes - 3 * 60) / (12 * 60);
		double minuteAngle = 2 * Math.PI * (minutes - 15) / 60;
		Line2D.Double hour= new Line2D.Double(150, 50, 150 + (int) (30 * Math.cos(hourAngle)),
				50 + (int) (30 * Math.sin(hourAngle)));
		g2.draw(hour);
		Line2D.Double m= new Line2D.Double(150, 50, 150 + (int) (45 * Math.cos(minuteAngle)),
				50 + (int) (45 * Math.sin(minuteAngle)));
		g2.draw(m);
	}

	public void setLabels() { // Doesn't handle midnight
		int hours = minutes / 60;
		int min = minutes - hours * 60;
		hourLabel.setText(hours + ":");
		if (min < 10) // Minutes should be two digits
			minuteLabel.setText("0" + min);
		else
			minuteLabel.setText("" + min);
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == tickButton)
			minutes++;
		else
			minutes = 720; // 12 noon
		repaint(); // Repaint redraws the circle and lines
		setLabels(); // setLabels resets the hour and minute text
	}
}